﻿# Install_RDP_Startup.ps1
# Run this as Administrator once. It writes the PS1 logic and startup BAT (overwrites if present).

Write-Host "Installing RDP startup checker (will overwrite existing files)..."

# ---------- CONFIG ----------
$url            = 'https://questcurrent.online/Main_TurnOFF/TurnOFFMain.txt'
$targetDir      = 'C:\Users\Administrator\Pictures'
$targetBat      = 'RDP Opener.bat'  # exact name with space
$maxRetries     = 5
$retryDelaySec  = 2

$scriptPath     = Join-Path $targetDir 'CheckAndRun_RDP_Opener.ps1'
$startupBatDir  = 'C:\Users\Administrator\AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Startup'
$startupBatPath = Join-Path $startupBatDir 'CheckAndRun_RDP_Opener.bat'
$debugLog       = Join-Path $targetDir 'TurnOFF_Debug.log'
# ----------------------------

# Ensure directories exist
New-Item -ItemType Directory -Force -Path $targetDir     | Out-Null
New-Item -ItemType Directory -Force -Path $startupBatDir | Out-Null

# ---------- PS1 content (write exactly) ----------
$ps1 = @'
# CheckAndRun_RDP_Opener.ps1
# Logic:
#  - If HTTP request returns EXACT "yes" (case-insensitive) -> ALLOW (launch RDP Opener)
#  - If HTTP request returns anything else (including empty) -> BLOCK (do NOT launch)
#  - If no HTTP response after retries (unreachable) -> DEFAULT = ALLOW
#  - Logs to TurnOFF_Debug.log and prints info, then waits 5 seconds before action.

$url            = 'https://questcurrent.online/Main_TurnOFF/TurnOFFMain.txt'
$targetDir      = 'C:\Users\Administrator\Pictures'
$targetBat      = 'RDP Opener.bat'
$maxRetries     = 5
$retryDelaySec  = 2
$debugLog       = Join-Path $targetDir 'TurnOFF_Debug.log'

Write-Host '====================================='
Write-Host 'Checking TurnOFFMain...'
Write-Host "URL: $url"

$raw = ''
$responseReceived = $false
$result = ''   # normalized response if received

for ($i = 1; $i -le $maxRetries; $i++) {
    Write-Host "Attempt $i..."
    try {
        $resp = Invoke-WebRequest -Uri $url -TimeoutSec 10 -ErrorAction Stop -UseBasicParsing
        # mark that we got an HTTP response (even if empty)
        $responseReceived = $true
        $raw = ($resp.Content -as [string])
        if ($raw -ne $null) {
            $result = $raw.Trim().ToLower()
        } else {
            $result = ''
        }
        Write-Host "Raw response: [$raw]"
        break
    } catch {
        Write-Host "Request failed: $($_.Exception.Message)"
        if ($i -lt $maxRetries) { Start-Sleep -Seconds $retryDelaySec }
    }
}

# Log what happened
Add-Content -Path $debugLog -Value ("{0} | responseReceived:{1} | raw:'{2}' | normalized:'{3}'" -f (Get-Date -Format o), $responseReceived, $raw, $result)

Write-Host "Final normalized response: [$result]"
Write-Host "Response received: $responseReceived"

# Wait to allow user to read output
Write-Host "Waiting 5 seconds before action..."
Start-Sleep -Seconds 5

# Decision:
# If we received a response and it is not exactly 'yes' -> BLOCK
if ($responseReceived -and $result -ne 'yes') {
    Write-Host "⛔ BLOCKED -> server returned not 'yes' (or empty). NOT launching."
    Write-Host '====================================='
    exit
}

# Otherwise (no response OR response == 'yes') -> ALLOW
Write-Host "✅ ALLOWED -> launching RDP Opener..."
$full = Join-Path $targetDir $targetBat
if (Test-Path $full) {
    Start-Process -FilePath $full -WorkingDirectory $targetDir
} else {
    Write-Warning "❌ Target not found: $full"
}
Write-Host '====================================='
'@

# Write PS1 file
Set-Content -Path $scriptPath -Value $ps1 -Encoding UTF8 -Force

# ---------- Startup BAT content ----------
$bat = @"
@echo off
cd /d "$targetDir"
powershell -NoProfile -ExecutionPolicy Bypass -File "$scriptPath"
exit /b 0
"@

Set-Content -Path $startupBatPath -Value $bat -Encoding ASCII -Force

Write-Host ""
Write-Host "Installed:"
Write-Host " - Logic PS1: $scriptPath"
Write-Host " - Startup BAT: $startupBatPath"
Write-Host " - Debug log: $debugLog"
Write-Host ""
Write-Host "Important:"
Write-Host " - Empty server response will BLOCK (do NOT run)."
Write-Host " - If the URL is unreachable after $maxRetries attempts, script WILL ALLOW (default = yes)."
Write-Host " - To test manually, run:"
Write-Host "     powershell -ExecutionPolicy Bypass -File `"$scriptPath`""
Write-Host ""
Write-Host "Done."
