﻿# set_rdp_resolution.ps1
# For every .rdp in this folder, set/add:
#   desktopwidth:i:<width>
#   desktopheight:i:<height>

$folder       = Split-Path -LiteralPath $MyInvocation.MyCommand.Path
Set-Location  $folder

$targetWidth  = 1366
$targetHeight = 768

# grab every .rdp in current folder
Get-ChildItem -Path . -Filter '*.rdp' | ForEach-Object {
    $file = $_.FullName

    # read all lines
    $lines  = Get-Content -LiteralPath $file
    $foundW = $false
    $foundH = $false

    # rewrite width/height lines, remember if we saw them
    $out = $lines | ForEach-Object {
        if ($_ -match '^desktopwidth:i:') {
            $foundW = $true
            "desktopwidth:i:$targetWidth"
        }
        elseif ($_ -match '^desktopheight:i:') {
            $foundH = $true
            "desktopheight:i:$targetHeight"
        }
        else {
            $_
        }
    }

    # if either line was missing, append it
    if (-not $foundW) { $out += "desktopwidth:i:$targetWidth" }
    if (-not $foundH) { $out += "desktopheight:i:$targetHeight" }

    # overwrite the file
    $out | Set-Content -LiteralPath $file

    Write-Host "Updated resolution in $file" -ForegroundColor Green
}

Write-Host "All done!" -ForegroundColor Cyan
