﻿# === Set working directory ===
$scriptDir = Split-Path -Parent $MyInvocation.MyCommand.Path
Set-Location $scriptDir
Write-Host "`n🔍 Updating credentials in folder: $scriptDir"

# === Apply system-wide bypass for cert/publisher warnings ===
try {
    $regPath = "HKCU:\Software\Microsoft\Terminal Server Client"
    if (-not (Test-Path $regPath)) {
        New-Item -Path $regPath -Force | Out-Null
    }
    Set-ItemProperty -Path $regPath -Name "AuthenticationLevelOverride" -Value 0 -Type DWord -Force
    Write-Host "🔧 Registry updated: AuthenticationLevelOverride = 0 (cert/publisher warnings bypassed)"
} catch {
    Write-Host "⚠️ Failed to update registry: $($_.Exception.Message)"
}

# === Get all RDP files ===
$rdpFiles = Get-ChildItem -Path $scriptDir -Filter "*.rdp"

if ($rdpFiles.Count -eq 0) {
    Write-Host "❌ No .rdp files found."
    exit
}

# === Credentials ===
$rdpUser = "Administrator"
$rdpPass = "Zahid5858@@"

foreach ($file in $rdpFiles) {
    try {
        $content = Get-Content $file.FullName -Raw
        if ($content -match "full address:s:(.+?)\r?\n") {
            $rdpHost = $matches[1].Trim()
            cmdkey /generic:"$rdpHost" /user:$rdpUser /pass:$rdpPass | Out-Null
            Write-Host "✅ Password updated for: $rdpHost ($($file.Name))"
        } else {
            Write-Host "⚠️ No full address found in: $($file.Name)"
        }
    } catch {
        Write-Host "❌ Failed to process $($file.Name): $($_.Exception.Message)"
    }
}

Write-Host "`n🎯 All credentials updated to '$rdpPass'"
