const config = {
    version: '3.34',
    // proxyGateHost: '69.39.235.33',
    
    // proxyGateHost: '10.37.129.2',
    proxyGateHost: '78.46.86.231',
    proxyGatePort: 8081,
    useLocalProxyGate: false,
    debugLevel: 0, //higher - more output
    widgetLoadTimeoutSeconds: 15,
    browserEnvironment: null,
    closeTabsAfterTask: true,
    proxyConfigs: [
        {
          "proxyOnQueues": [5, 23],
          "proxyOffQueues": [6, 24],
          "name": "recaptcha",
          "tunnelHosts": [
            "www.google.com"
          ],
          "tunnelPaths": [
            "/recaptcha/api.js",
            "/recaptcha/enterprise.js",
            "/recaptcha/api2/userverify",
            "/recaptcha/api2/anchor",
            "/recaptcha/api2/bframe",
            "/recaptcha/api2/reload",
            "/recaptcha/api2/replaceimage",
            "/recaptcha/api2/payload",
            "/recaptcha/enterprise/anchor",
            "/recaptcha/enterprise/reload",
            "/recaptcha/enterprise/bframe",
            "/recaptcha/enterprise/userverify",
            "/recaptcha/enterprise/replaceimage",
            "/recaptcha/enterprise/payload"
          ],
          "excludeHosts": [],
          "errorIndicationUrls": [
            {
              "path": "api.js",
              "statusCode": 403,
              "errorText": "invalid site key",
              "errorId": 31
            },{
              "path": "api.js",
              "statusCode": 400,
              "errorText": "worker is glitching",
              "errorId": 41
            },{
              "path": "anchor",
              "statusCode": 400,
              "errorText": "connection failed",
              "errorId": 25
            }
          ],
          "loadedIndicationUrls": [
            "anchor",
            "bframe",
            "reload?k",
            "webworker.js"
          ]
        },{
          "proxyOnQueues": [],
          "proxyOffQueues": [18, 19, 20],
          "name": "recaptcha",
          "tunnelHosts": [
            "www.google.com"
          ],
          "tunnelPaths": [
            "/recaptcha/api.js",
            "/recaptcha/enterprise.js",
            "/recaptcha/api2/userverify",
            "/recaptcha/api2/anchor",
            "/recaptcha/api2/bframe",
            "/recaptcha/api2/reload",
            "/recaptcha/api2/replaceimage",
            "/recaptcha/api2/payload",
            "/recaptcha/enterprise/anchor",
            "/recaptcha/enterprise/reload",
            "/recaptcha/enterprise/bframe",
            "/recaptcha/enterprise/userverify",
            "/recaptcha/enterprise/replaceimage",
            "/recaptcha/enterprise/payload"
          ],
          "excludeHosts": [],
          "errorIndicationUrls": [
            {
              "path": "api.js",
              "statusCode": 403,
              "errorText": "invalid site key",
              "errorId": 31
            },{
              "path": "api.js",
              "statusCode": 400,
              "errorText": "invalid site key",
              "errorId": 31
            },{
              "path": "anchor",
              "statusCode": 400,
              "errorText": "connection failed",
              "errorId": 25
            }
          ],
          "loadedIndicationUrls": [
            "anchor",
            "bframe",
            "reload?k",
            "webworker.js"
          ]
        },{
            "proxyOnQueues": [7],
            "proxyOffQueues": [10],
            "name": "funcaptcha",
            "tunnelHosts": [
                'funcaptcha.com',
                '*.funcaptcha.com',
                'arkoselabs.com',
                '*.arkoselabs.com',
            ],
            "tunnelPaths": ["/"],
            "excludeHosts": [
                'cdn.arkoselabs.com',
                'cdn.funcaptcha.com',
            ],
            "errorIndicationUrls": [
                {
                    path: "public_key",
                    statusCode: 400,
                    errorText: "got 400 error while loading public_key",
                    errorId: 52
                },{
                    path: "/fc/api",
                    statusCode: 400,
                    errorText: "connection refused",
                    errorId: 25
                }
            ],
            "loadedIndicationUrls": [
                "/fc/a/",
                "fc_bootstrap",
                "challenge=",
                "ui",
                "settings"
            ]
        },{
            "proxyOnQueues": [12],
            "proxyOffQueues": [13],
            "name": "geetest",
            "tunnelHosts": [
                'api.geetest.com',
                'api-na.geetest.com',
                'api-*.geetest.com',
                'gcaptcha4.geetest.com'
            ],
            "tunnelPaths": ["/"],
            "excludePaths": [],
            "excludeHosts": [],
            "errorIndicationUrls": [],
            "loadedIndicationUrls": [
                "gettype.php",
                "get.php",
                "ajax.php",
                "load?c",
                "/v4/"
            ]
        },{
            "proxyOnQueues": [21],
            "proxyOffQueues": [22],
            "name": "hcaptcha",
            "tunnelHosts": [
                'hcaptcha.com',
                'api.hcaptcha.com',
                'api2.hcaptcha.com',
                'newassets.hcaptcha.com'
            ],
            "tunnelPaths": ["/"],
            "excludeHosts": [],
            "errorIndicationUrls": [
                {
                    path: "https://hcaptcha.com/checksiteconfig",
                    statusCode: 403,
                    errorText: "invalid site key",
                    errorId: 31
                },{
                    path: "api.js",
                    statusCode: 400,
                    errorText: "connection failed",
                    errorId: 25
                }
            ],
            "loadedIndicationUrls": [
                "hcaptcha.html",
                "checksiteconfig",
                "/getcaptcha/"
            ]
        },{
            "proxyOnQueues": [26],
            "proxyOffQueues": [27],
            "name": "turnstile",
            "tunnelHosts": [
                'challenges.cloudflare.com'
            ],
            "tunnelPaths": [
                "/cdn-cgi/challenge-platform",
                "/turnstile"
            ],
            "excludeHosts": [],
            "errorIndicationUrls": [
                {
                    path: "https://challenges.cloudflare.com/cdn-cgi/challenge-platform",
                    statusCode: 400,
                    errorText: "invalid site key",
                    errorId: 31
                },{
                    path: "api.js",
                    statusCode: 400,
                    errorText: "connection refused",
                    errorId: 25
                },{
                    path: "https://challenges.cloudflare.com/cdn-cgi/challenge-platform",
                    statusCode: 403,
                    errorText: "invalid domain for site key",
                    errorId: 32
                }
            ],
            "loadedIndicationUrls": [
                "cdn-cgi/challenge"
            ]
        },{
            "proxyOnQueues": [29],
            "proxyOffQueues": [30],
            "name": "prosopo",
            "tunnelHosts": [
                'pronode*.prosopo.io'
            ],
            "tunnelPaths": [
                "/v1/prosopo/provider/client/captcha/frictionless",
                "/v1/prosopo/provider/client/captcha/pow",
                "/v1/prosopo/provider/client/pow/solution"
            ],
            "excludeHosts": [],
            "errorIndicationUrls": [
                {
                    path: "captcha/frictionless",
                    statusCode: 400,
                    errorText: "invalid site key",
                    errorId: 31
                }
            ],
            "loadedIndicationUrls": [
                "captcha/frictionless"
            ]
        },{
            "proxyOnQueues": [31],
            "proxyOffQueues": [32],
            "name": "friendlycaptcha",
            "tunnelHosts": [
                'sentry.frcapi.com',
                'global.frcapi.com'
            ],
            "tunnelPaths": [
                "/api/v2/captcha/redeem",
                "/api/v2/captcha/widget",
                "/api/v2/captcha/agent",
                "/api/3/envelope",
                "/api/v2/captcha/activate",
                "/api/v2/captcha/quote"
            ],
            "excludeHosts": [],
            "errorIndicationUrls": [
                {
                    path: "captcha/activate",
                    statusCode: 500,
                    errorText: "invalid site key",
                    errorId: 31
                },{
                    path: "captcha/activate",
                    statusCode: 403,
                    errorText: "invalid site key",
                    errorId: 31
                }
            ],
            "loadedIndicationUrls": [
                "envelope",
                "agent",
                "widget"
            ]
        },{
            "proxyOnQueues": [33],
            "proxyOffQueues": [34],
            "name": "amazon",
            "tunnelHosts": [
                '*.captcha.awswaf.com',
                '*.token.awswaf.com'
            ],
            "tunnelPaths": [
                "inputs?client=browser",
                "report",
                "problem",
                "telemetry",
                "verify",
                "voucher"
            ],
            "excludeHosts": [],
            "errorIndicationUrls": [
                {
                    path: "verify",
                    statusCode: 400,
                    errorText: "invalid site key",
                    errorId: 31
                }
            ],
            "loadedIndicationUrls": [
                "problem",
                "telemetry",
                "verify"
            ]
        },{
            "proxyOnQueues": [35],
            "proxyOffQueues": [36],
            "name": "altcha",
            "tunnelHosts": [

            ],
            "tunnelPaths": ["/"],
            "excludePaths": [],
            "excludeHosts": [],
            "errorIndicationUrls": [{
                path: "/",
                statusCode: 400,
                errorText: "invalid site key",
                errorId: 31
            },{
                path: "/",
                statusCode: 404,
                errorText: "invalid site key",
                errorId: 31
            },{
                path: "/",
                statusCode: 503,
                errorText: "failed with 503",
                errorId: 52
            }],
            "loadedIndicationUrls": [
                "/"
            ]
        }
    ],
    noProxyHosts: [
        'antcpt.com',
        'kolotibablo.com',
        'www.kolotibablo.com',
        '*.kolotibablo.com',
        'anti-captcha.com',
        'docker.anti-captcha.com',
        'docker.kolotibablo.com',
        'docker-boss.anti-captcha.com',
        'boss.anti-captcha.com'
    ],
    alwaysBlockHostnames: [
        'clients.google.com',
        'clients1.google.com',
        'clients3.google.com',
        'clients4.google.com',
        'clients5.google.com',
        'clients6.google.com',
        'clients7.google.com',
        'clients8.google.com',
        'clients9.google.com',
        'clients0.google.com'
    ]
}


const manifestData = chrome.runtime.getManifest();
config['manifest_version'] = manifestData.manifest_version;

//downgrading
if (typeof chrome.declarativeNetRequest === "undefined") config['manifest_version'] = 2;

config['browserEnvironment'] = typeof browser === "undefined" ? 'Chrome' : 'Firefox'
config['browserPostfix'] = (typeof browser === "undefined") ? '1' : '2';
config['devicePostfix'] = !(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) ? '1' : '2';
config['pluginVersion'] = config.version + config['manifest_version'].toString() + config['browserPostfix'] + config['devicePostfix'];

export { config }