const overrideKey = () => {
  const observer = new MutationObserver(() => {
    const hcaptchaFrames = document.querySelectorAll('iframe[src*="hcaptcha.com"]');
    hcaptchaFrames.forEach((frame) => {
      let src = frame.getAttribute('src');
      if (src && !src.includes('10000000-ffff-ffff-ffff-000000000001')) {
        const updated = src.replace(/sitekey=([^&]+)/, 'sitekey=10000000-ffff-ffff-ffff-000000000001');
        frame.setAttribute('src', updated);
      }
    });
  });

  observer.observe(document.documentElement, { childList: true, subtree: true });
};

overrideKey();