// background.js — proxy fetch to AWS (bypasses CORS)
chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
  if (msg.type === "predict") {
    fetch("http://18.219.71.63:8000/predict", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({
        class_name: msg.class_name,
        image_base64: msg.image_base64,
        conf_threshold: 0.1,
        iou_threshold: 0.1,
        img_size: 500
      })
    })
      .then(r => r.json())
      .then(data => sendResponse({ success: true, data }))
      .catch(err => sendResponse({ success: false, error: err.toString() }));
    return true; // async
  }
});
