var background = (function () {
  "use strict";
  const p = globalThis.browser?.runtime?.id
    ? globalThis.browser
    : globalThis.chrome;
  function O(c) {
    return c == null || typeof c == "function" ? { main: c } : c;
  }
  const o = typeof p < "u" ? p : typeof chrome < "u" ? chrome : null,
    A = O(() => {
      function c() {
        o.contextMenus
          .removeAll()
          .then(() => {
            [
              { title: "Pick the OCR Type", id: "ocrid", contexts: ["page"] },
              {
                title: "Pick the OCR image element",
                id: "ocrPicker",
                contexts: ["page"],
              },
              {
                title: "Pick the input element",
                id: "inputPicker",
                contexts: ["page"],
              },
              {
                title: "Probot",
                parentId: "ocrid",
                id: "probot",
                contexts: ["page"],
              },
              {
                title: "Amazon",
                parentId: "ocrid",
                id: "amazon",
                contexts: ["page"],
              },
            ].forEach((t) => {
              o.contextMenus.create(t, () => {
                o.runtime.lastError &&
                  console.error(
                    "Context menu creation error:",
                    o.runtime.lastError,
                  );
              });
            });
          })
          .catch((e) => console.error("Error removing context menus:", e));
      }
      o.contextMenus.onClicked.addListener((e, t) => {
        if (!t?.id) return;
        const n = {
          menuItemId: e.menuItemId,
          ...(e.menuItemId === "ocrPicker" && { picker: "ocrPicker" }),
          ...(e.menuItemId === "inputPicker" && { picker: "inputPicker" }),
        };
        o.tabs.sendMessage(t.id, n, (r) => {
          o.runtime.lastError &&
            console.error("Message sending error:", o.runtime.lastError);
        });
      });
      const h = {
        "User-Agent":
          "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36",
        Accept:
          "image/avif,image/webp,image/apng,image/svg+xml,image/*,*/*;q=0.8",
        "Accept-Language": "en-US,en;q=0.9",
        "Sec-Fetch-Mode": "no-cors",
      };
      o.runtime.onMessage.addListener((e, t, n) => {
        if (e.type === "GET_IMAGE_BASE64") {
          const { url: r, headers: u = {} } = e.payload,
            d = { ...h, ...u };
          return (
            fetch(r, { headers: d })
              .then((a) => a.arrayBuffer())
              .then((a) => {
                const i = new Uint8Array(a).reduce(
                    (f, l) => f + String.fromCharCode(l),
                    "",
                  ),
                  s = `${btoa(i)}`;
                n({ success: !0, data: s });
              })
              .catch((a) => {
                n({ success: !1, error: a.message });
              }),
            !0
          );
        }
        




        if (e.type === "networkRequest") {
  // ===============================
  // Parse original createTask body
  // ===============================
  let originalTask = null;
  try {
    originalTask = e.payload?.body
      ? JSON.parse(e.payload.body)
      : null;
  } catch (_) {}

  // ===============================
  // PRE-SOLVE LOCAL CACHE CHECK
  // ===============================
  if (
    originalTask?.task &&
    originalTask.task.type === "PopularCaptchaImage"
  ) {
    const task = originalTask.task;

    return (
      fetch("http://127.0.0.1:8000/check", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({
          question: task.question,
          questionType: task.questionType,
          queries: task.queries, // ORDER PRESERVED
        }),
      })
        .then((res) => (res.ok ? res.json() : Promise.reject()))
        .then((cached) => {
          // ✅ CACHE HIT — RETURN IMMEDIATELY
          if (
            cached &&
            cached.code === 200 &&
            Array.isArray(cached.answers)
          ) {
            return n({
              success: true,
              data: cached,
              cache: true,
            });
          }

          // ❌ CACHE MISS → REAL SOLVER
          return b(e.payload).then((r) =>
            n({ success: true, data: r })
          );
        })
        .catch(() =>
          b(e.payload).then((r) =>
            n({ success: true, data: r })
          )
        ),
      true
    );
  }

  // ===============================
  // FALLBACK — NON CAPTCHA REQUEST
  // ===============================
  return (
    b(e.payload)
      .then((r) => n({ success: true, data: r }))
      .catch((err) => n({ success: false, error: err.message })),
    true
  );
}









        // if (e.type === "feedback")
        //   return (
        //     fetch("https://feedback.captchasonic.com/reportAccuracy", {
        //       method: "POST",
        //       headers: { "Content-Type": "application/json" },
        //       body: JSON.stringify(e.payload),
        //     })
        //       .then((r) => r.json())
        //       .then((r) => {
        //         n({ success: !0, data: r });
        //       })
        //       .catch((r) => {
        //         n({ success: !1, error: r.message });
        //       }),
        //     !0
        //   );


        if (e.type === "feedback") {
            // intentionally disabled
            return true;
          };







        if (e.action === "getTabId")
          return (
            t.tab
              ? n({ tabId: t.tab.id })
              : chrome.tabs.query({ active: !0, currentWindow: !0 }, (r) => {
                  const u = r[0]?.id || null;
                  n({ tabId: u });
                }),
            !0
          );
        if (e.type === "whileLoopCheck")
          return (
            chrome.tabs.query({ active: !0, currentWindow: !0 }, (r) => {
              r[0] && n({ message: "globalCallback" });
            }),
            !0
          );
        if (e.action === "solveTurnstile")
          return (
            w(e.payload)
              .then((r) => {
                n({ success: !0, data: r });
              })
              .catch((r) => n({ success: !1, error: r.message })),
            !0
          );
        if (e.action === "getActiveTabUrl")
          return (
            chrome.tabs.query({ active: !0, currentWindow: !0 }, (r) => {
              const u = r[0];
              n({ url: u.url });
            }),
            !0
          );
        if (e.type === "triggerCallback") {
          const r = t.tab?.id;
          return (
            r &&
              o.tabs.sendMessage(r, {
                action: "executeCallback",
                callbackName: e.callbackName,
              }),
            !0
          );
        }
        (e.type === "error_notification" ||
          e.type === "solution_notification") &&
          new Set([
            "popularCaptcha_refresh_iframes",
            "ReCaptcha_refresh_iframes",
            "ERROR_BAD_PARAMETERS",
            "ERROR_TOO_BIG_CAPTCHA_FILESIZE",
            "ERROR_ZERO_CAPTCHA_FILESIZE",
            "ERROR_CAPTCHA_UNSOLVABLE",
            "ERROR_BAD_IMGINSTRUCTIONS",
            "ERROR_BAD_DUPLICATES",
            "ERROR_NO_SUCH_METHOD",
            "ERROR_KEY_DOES_NOT_EXIST",
            "ERROR_ZERO_BALANCE",
            "ERROR_DAILY_LIMIT_EXCEEDED",
            "ERROR_QUOTA_LIMIT_EXCEEDED",
            "ERROR_MINUTE_LIMIT_EXCEEDED",
            "API_KEY_NOT_FOUND!",
            "solving",
            "solved",
          ]).has(e.action) &&
          C(e);
      });
      async function w({ websiteURL: e, websiteKey: t, userAgent: n }) {
        const d = await (
          await fetch("https://api.captchasonic.com/createTask", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({
              apiKey: "",
              task: {
                type: "AntiTurnstileTaskProxyLess",
                websiteURL: e,
                websiteKey: t,
                userAgent: n,
              },
            }),
          })
        ).json();
        if (!d.taskId)
          throw new Error(
            "Failed to create CAPTCHA task: " + JSON.stringify(d),
          );
        const a = d.taskId,
          i = 20,
          E = 3e3;
        let s = 0;
        for (; s < i; ) {
          const l = await (
            await fetch("https://api.captchasonic.com/getTaskResult", {
              method: "POST",
              headers: { "Content-Type": "application/json" },
              body: JSON.stringify({ apiKey: "", taskId: a }),
            })
          ).json();
          if (l.status === "ready") return l.solution;
          if (l.status === "failed") throw new Error("CAPTCHA solving failed.");
          (await new Promise((_) => setTimeout(_, E)), s++);
        }
        throw new Error("CAPTCHA solving timed out.");
      }
      async function b({ url: e, method: t, headers: n, body: r }) {
        const u = await fetch(e, {
          method: t || "GET",
          headers: n || {},
          body: t !== "GET" ? r : void 0,
        });
        if (!u.ok) throw new Error(`HTTP error! status: ${u.status}`);
        return u.headers.get("content-type")?.includes("application/json")
          ? await u.json()
          : await u.text();
      }
      async function C(e) {
        try {
          const [t] = await o.tabs.query({ active: !0, currentWindow: !0 });
          if (!t?.id) return;
          await o.tabs.sendMessage(t.id, e);
        } catch (t) {
          console.error("Error querying active tab:", t);
        }
      }
      async function S() {
        try {
          const e = await fetch(o.runtime.getURL("config/defaultConfig.json"));
          return e.ok ? await e.json() : null;
        } catch (e) {
          return (console.error("Error loading default config:", e), null);
        }
      }
      o.runtime.onInstalled.addListener(async (e) => {
        c();
        const t = await S();
        if (e.reason === "install") {
          const n = await I();
          try {
            let r = await o.storage.local.get("userID");
            (await o.storage.local.set({ userID: n }), m("install", n));
          } catch (r) {
            console.error("Error accessing storage:", r);
          }
          (t && (await o.storage.local.set({ settings: t })), t.GUIDE_PAGE);
        }
        if (e.reason === "update") {
          let E = function (s, f) {
            return (
              (s = s.filter((l) => f.includes(l))),
              f.forEach((l) => {
                s.includes(l) || s.push(l);
              }),
              s
            );
          };
          const n = await I();
          try {
            let s = await o.storage.local.get("userID");
            (await o.storage.local.set({ userID: n }), m("update", n));
          } catch (s) {
            console.error("Error accessing storage:", s);
          }
          const r = await o.storage.local.get("settings"),
            u = await o.storage.sync.get("settings"),
            a = (r?.settings ? r : u).settings || {};
          let i = { ...t };
          ((i.APIKEY = t.APIKEY || a.APIKEY || ""),
            (i.ACTIVE = a.ACTIVE ?? t.ACTIVE),
            (i.THEME = a.THEME || t.THEME),
            (i.BLACKLISTENABLED = a.BLACKLISTENABLED ?? t.BLACKLISTENABLED),
            (i.AUTOOPENENABLED = a.AUTOOPENENABLED ?? t.AUTOOPENENABLED),
            (i.LOGENABLED = a.LOGENABLED ?? t.LOGENABLED),
            (i.Local_lang = a.Local_lang || t.Local_lang),
            (i.NOTIFICATION = a.NOTIFICATION ?? t.NOTIFICATION),
            (i.CAPTCHAS = E(a.CAPTCHAS || [], t.CAPTCHAS)),
            (i.TITLES = E(a.TITLES || [], t.TITLES)),
            (i.OPTIONS = { ...a.OPTIONS }));
          for (const s of Object.keys(t.OPTIONS))
            i.OPTIONS[s]
              ? (i.OPTIONS[s] = { ...t.OPTIONS[s], ...a.OPTIONS[s] })
              : (i.OPTIONS[s] = t.OPTIONS[s]);
          (await o.storage.local.set({ settings: i }),
            console.log("Extension updated - settings merged successfully"));
        }
      });
      async function I() {
        let e = {
          browser: navigator.userAgent,
          platform: navigator.platform,
          language: navigator.language,
          timezone: Intl.DateTimeFormat().resolvedOptions().timeZone,
          cpuCores: navigator.hardwareConcurrency || "unknown",
          deviceMemory: navigator.deviceMemory || "unknown",
          installTimestamp: Date.now(),
        };
        return btoa(JSON.stringify(e));
      }
      async function m(e, t) {
        try {
          const n = await fetch("https://api.captchasonic.com/collect", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({
              event: e,
              userID: t,
              timestamp: Date.now(),
            }),
          });
          n.ok || console.error(`Failed to send ${e} event:`, n.status);
        } catch (n) {
          console.error(`Error sending ${e} event:`, n);
        }
      }
      o.runtime.onStartup.addListener(() => {
        console.log("Extension initialized");
      });
    });
  function P() {}
  function T(c, ...h) {}
  const y = {
    debug: (...c) => T(console.debug, ...c),
    log: (...c) => T(console.log, ...c),
    warn: (...c) => T(console.warn, ...c),
    error: (...c) => T(console.error, ...c),
  };
  let g;
  try {
    ((g = A.main()),
      g instanceof Promise &&
        console.warn(
          "The background's main() function return a promise, but it must be synchronous",
        ));
  } catch (c) {
    throw (y.error("The background crashed on startup!"), c);
  }
  return g;
})();
